//=============================================================================
// Defense trigger, turns on doors and spawns crap.
//=============================================================================
class MSMDefTrigger extends Trigger;

var() float OnTime, OnTimer;
var bool bOn;
var() class<Actor> SpawnClass;
var() name TargetDoor;
var() string ChangeProps[5];
var() string ChangeValues[5];
var() rotator SpawnRot;
var() bool bSetBase;
var actor LastAct;

function Trigger(Actor Other, Pawn EventInstigator)
{
 local actor TempAct;
 local int i;
 local DeusExMover DXM;
 
 if (OnTimer > 0) return; //don't trigger again until its ready
 
 TempAct = Spawn(SpawnClass, EventInstigator,,Location,SpawnRot);
 LastAct = TempAct;
 
 for(i=0; i<5; i++)
 {
  if (ChangeProps[i] != "" && ChangeValues[i] != "")
  {
   TempAct.SetPropertyText(ChangeProps[i], ChangeValues[i]);
  }
 }
 
 forEach AllActors(class'DeusExMover', DXM, TargetDoor)
 {
  if (DXM != None)
  {
   DXM.DoOpen();
   if (bSetBase) TempAct.SetBase(DXM);
   break;
  }
 }
 
 OnTimer = OnTime;
 bOn = True;
}

function Tick(float D)
{
 local DeusExMover DXM;

 Super.Tick(D);
 
 if (OnTimer > 0 && bOn)
 {
  OnTimer -= D;
  
  if (OnTimer <= 0 && bOn)
  {
   bOn = False;

    forEach AllActors(class'DeusExMover', DXM, TargetDoor)
    {
     if (DXM != None)
     {
      if (bSetBase) LastAct.SetBase(None);
      DXM.DoClose();
      break;
     }
    }
  }
 }
}

defaultproperties
{
 bCollideActors=False
}
